#include <stdio.h>
#include <stdlib.h>
#include <linux/dimmio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>

//Macros for light states

#define ON 255
#define OFF 0

/* Configures a pin by port and bit number */
void set_config_by_port_bit(struct dimm_io *pin,
			    int handle,
			    short port,
			    short bit,
			    unsigned char mode,
			    unsigned char pull_up_dn) 
{
  int error;
  
  pin->port_number = port;
  pin->bit_number = bit;
  pin->mode = mode;
  pin->pull_up_dn = pull_up_dn;
  
  error = ioctl(handle, DIMM_IO_IOCTL_SET_CONFIG_BY_PORT_BIT, pin);
  if (error <0) 
    {
      fprintf(stderr, "Unable to configure device. Error code: %i\n", errno);
      close(handle);
      exit(1);
    }
}


/* Reads a pin using offset */
void read_by_offset(struct dimm_io *pin, int handle) 
{
  int error;

  lseek(handle, pin->offset, SEEK_SET);
  error = read(handle, &(pin->state), 1);
  if (error <0) 
    {
      fprintf(stderr, "Error in reading from device.  Error code: %i\n", errno);
      close(handle);
      exit(1);
    }
}


/* Writes a value to a pin using offset */
void write_by_offset(struct dimm_io *pin, int handle) 
{
  int error;
  
  lseek(handle, pin->offset, SEEK_SET);
  error = write(handle, &(pin->state), 1);
  if (error <0) 
    {
      fprintf(stderr, "Error in writing to device\n");
      close(handle);
      exit(1);
    }
}

int pow2(int i)
{
  int iReturn = 1;
  while(i--)
    {
      iReturn*=2;
    }
  return iReturn;
}

int setval(int i,int handle,int port) 
{
  int j;
  struct dimm_io P[8],L,E;
  /* Enable/Unlatch output */
  set_config_by_port_bit(&L,handle,9,0,1,0);
  set_config_by_port_bit(&E,handle,9,2,1,0);
  L.state=0;
  E.state=1;
  write_by_offset(&L,handle);
  write_by_offset(&E,handle);
  for(j=0;j<8;j++)
    {
      /* Port bits, output, pull-up/pull-down disabled */
      set_config_by_port_bit(&P[j], handle, port, j, 1, 0);
      P[j].state = (pow2(j) & i) ? 1:0;
      write_by_offset(&P[j],handle);
    }
  return i;
}

int setmode(int mode,int handle, int port, int pin)
{
  struct dimm_io p;
  /* Port bits, output, pull-up/pull-down disabled */
  set_config_by_port_bit(&p, handle, port, pin, 1, 0);
  p.state=mode;
  write_by_offset(&p,handle);
  return p.state;
}

int togglee(handle)
{
   struct dimm_io p;
  /* Port bits, output, pull-up/pull-down disabled */
  set_config_by_port_bit(&p, handle, 10, 0, 1, 0);
  p.state=1;
  write_by_offset(&p,handle);
  usleep(1);
  p.state=0;
  write_by_offset(&p,handle);
  usleep(1);
  return p.state;
}

void cchars();

int main(int argc,char** argv)
 {
 char array[] = {
 	0x00, 0x0E, 0x1F, 0x1E, 0x0E, //rock
	0x1F, 0x16, 0x0D, //ground
	0x00, 0x00, 0x00, 0x00, 0x00,//nothing
	0x11, 0x1B, 0x1F, //hole
	0x00, 0x00, 0x00, 0x00, 0x00,//nothing
	0x1F, 0x16, 0x0D, //ground
	0x00, 0x0C, 0x1F, 0x1F, 0x0A, //car
	0x00, 0x00, 0x00, 0x00, //nothing
	0x0C, 0x1F, 0x1F, 0x0A, //car
	0x1F, 0x16, 0x0D}; //ground
   int x;
 
 
   int handle=0;
   handle = open("/dev/io1",O_RDWR);
   if (handle < 0) {
     printf("Unable to open device\n");
     exit(1);
   }
   
   //turn the lights off
   setval(OFF,handle,2);
   
   //Get LCD ready
   setmode(0,handle,10,0); //Enable low
   setmode(0,handle,3,6); //Set to write
   setmode(0,handle,3,5); //Set to instruction mode
   setval(1,handle,2); //Clear display
   togglee(handle);
   setval(0x38,handle,2); //Write 0x38
   togglee(handle);
   setval(0x0E,handle,2); //Write 0x0E
   togglee(handle);
   setval(0x06,handle,2); //Write 0x06
   togglee(handle);;


   setmode(0,handle,3,5); //Set to instruction mode
   setval(0x40,handle,2); //write to 0x00 
   togglee(handle);
   
   setmode(1,handle,3,5); // set to data mode
   
   for(x = 0; x<(5*8); x++)
   {
   	setval(array[x],handle,2); //write the custom characters
	togglee(handle);
	usleep(40);
   }

   setmode(0,handle,3,5); //Set to instruction mode
   setval(0x02,handle,2);
   togglee(handle);
   usleep(1640);
   setmode(1,handle,3,5);

/*
   setmode(1,handle,3,5); //Set to data mode
   setval('H',handle,2); 
   togglee(handle);   
   setval('e',handle,2); 
   togglee(handle);   
   setval('l',handle,2); 
   togglee(handle);   
   setval('l',handle,2); 
   togglee(handle);   
   setval('o',handle,2); 
   togglee(handle);   
   setval(' ',handle,2); 
   togglee(handle);   
   setval('W',handle,2); 
   togglee(handle);   
   setval('o',handle,2); 
   togglee(handle);   
   setval('r',handle,2); 
   togglee(handle);   
   setval('l',handle,2); 
   togglee(handle);   
   setval('d',handle,2); 
   togglee(handle);

   sleep(1);
  */


   setval(0x00,handle,2); 
   togglee(handle);   
   setval(0x01,handle,2); 
   togglee(handle);   
   setval(0x02,handle,2); 
   togglee(handle);   
   setval(0x02,handle,2); 
   togglee(handle);   
   setval(0x02,handle,2); 
   togglee(handle);   
   setval(0x02,handle,2); 
   togglee(handle);   
   setval(0x02,handle,2); 
   togglee(handle);   
   setval(0x03,handle,2);
   togglee(handle);   
   setval(0x04,handle,2); 
   togglee(handle);   
   setval(0x05,handle,2); //displays world for no reason
   togglee(handle);   
   
  
   close(handle);
   return 0;
}
