/*
 * Protocol: (All messages are UDP datagrams)
 *  - Clients connect to server by sending a JOIN command
 *  - Server replies with WLCM command
 *  - Server starts game by sending STRT command
 *  - Clients report score to server by sending SCOR command
 *  - Clients report player death by sending DEAD command
 *  - Server ends game by sending OVER command
 *
 *  JOIN:
 *    JOIN <playername>\n
 *
 *  WLCM:
 *    WLCM\n
 *
 *    Acknowledge JOIN
 *
 *  REDY:
 *    REDY <starttime>\n
 *
 *    starttime is the estimated time in CLOCKS_PER_SEC until the game will begin.
 *    0 means the time is unknown. Clients must wait for the STRT command
 *    before starting!
 *
 *  STRT:
 *    STRT <seed>\n
 *
 *    seed is the random seed of the level generator. All clients will recieve
 *    the same seed for a given game.
 *
 *  SCOR:
 *    SCOR <score>\n
 *
 *    score is the player's current score. This command will be issued to the
 *    server by the client once every second.
 *
 *  DEAD:
 *    DEAD <score>\n
 *
 *    score is the player's score at the time of death.
 *
 *  OVER:
 *    OVER <winnername> <score>\n
 *
 *    winnername is the name of the winner. score is the winner's score.
 *    The recieving client may only assume it is the winner if the score
 *    matches it's own, as duplicate player names are allowed.
 *
 *  QUIT:
 *    QUIT
 *
 *    Server closing, or player leaving game.
 *
 *  EROR:
 *    EROR
 *
 *    This command may be issued by either server or client at any time
 *    if the issuer recieves unexpected or otherwise erroneous data from
 *    the issuee.
 */

#define UNKNOWN_CMD 0
#define JOIN_CMD 1
#define WLCM_CMD 2
#define REDY_CMD 3
#define STRT_CMD 4
#define SCOR_CMD 5
#define DEAD_CMD 6
#define OVER_CMD 7
#define QUIT_CMD 8
#define EROR_CMD 10

